function den_est=LapDP_density_est(s,e,beta,r2,X,t)
% private nonparametric estimation using Laplacian mechanism instead of
% Gaussian.
    n=length(X);
    d=round((0.5*n*e^2*r2)^(1/(2*beta+3)));
    ortho_coeff=zeros(1,d);
    for i=1:n
        X_new=zeros(1,d);
        for j=1:d
            if mod(j,2)==1
                X_new(j)=sqrt(2)*sin(pi*(j-1)*X(i));
                %rng(s);
                X_new(j)=laprnd(1,1)*sqrt(2)*d/e;
            end
            if mod(j,2)==0
                X_new(j)=sqrt(2)*cos(pi*j*X(i));
                %rng(s);
                X_new(j)=laprnd(1,1)*sqrt(2)*d/e;
            end
        end
        ortho_coeff=ortho_coeff+X_new;
    end
    den_est=zeros(1,length(t));
    for k=1:d
        if mod(k,2)==1
            den_est=den_est+ortho_coeff(k)*sqrt(2)*sin(pi*(k-1)*t);
        end
        if mod(k,2)==0
            den_est=den_est+ortho_coeff(k)*sqrt(2)*cos(pi*k*t);
        end
    end
    den_est=ones(1,length(t))+den_est/n;
end
